﻿#include  "StdAfx.h"

#include  <szArchiveExtractor.hpp>
#include  <szCodecManager.hpp>
#include  <Common/MyCom.h>
#include  <Common/Wildcard.h>
#include  <7zip/UI/Common/Extract.h>
#include  <Windows/FileDir.h>
#include  "szArchiveFileExtractorImpl.hpp"

SZ_NS_BEG(szpp)

//ArchiveExtractor::ArchiveExtractor(
//  const ArchiveHandler *handler,
//  ArchiveVolume *volume)
//{
//}
//
//ArchiveExtractor::~ArchiveExtractor()
//{
//}

void ArchiveExtractor::Extract(const szstring &archivePath,
                               const szstring &outputDir,
                               const szstring *password,
                               ArchiveOpenClientCallback *openCallback,
                               ArchiveFileExtractClientCallback *extCallback,
                               GetPasswordClientCallback *pwdCallback)
{
  CMyComPtr<ArchiveFileExtractorImpl> impl(new ArchiveFileExtractorImpl(openCallback, extCallback, pwdCallback));

#ifndef _NO_CRYPTO
  // ファイル名が暗号化されていて列挙時にパスワードを問い合わせた、あるいは最初からパスワードが指定されているようなケースでは、それで初期化
  if (0 != password)
    impl->SetInitialPassword(*password);
#endif

  CIntVector formatIndices;

  UString arcPath = archivePath.c_str(), arcPathFull;
  NWindows::NFile::NDirectory::MyGetFullPathName(arcPath, arcPathFull);
  UStringVector arcPaths, arcPathsFull;
  arcPaths.Add(arcPath);
  arcPathsFull.Add(arcPathFull);

  // ワイルドカードはすべて展開するように設定しておく
  // Exclude マスクなんかを指定できるように改良するということも考えられる。
  NWildcard::CCensor censor;
  censor.AddItem(true, SZL("*"), false); // * を top\\second とすると top\\second 以下のファイルのみが展開される

  // その他のオプションを初期化
  // OverwriteMode を ExtractMode.h で定義されている kAskBefore/kWithoutPrompt/kSkipExisting/kAutoRename/kAutoRenameExisting のいずれかを
  // 選択できるようにするという改良も考えられるが、とりあえず epolight ではコールバックで上書きオプションをユーザーに尋ねるので、
  // 現在は kAskBefore で決め打ちしている。
  CExtractOptions eo;
  eo.StdInMode = false;
  eo.StdOutMode = false;
  eo.PathMode = NExtract::NPathMode::kFullPathnames; // パス名を無視するという選択肢は提供しない
  eo.TestMode = false; // これを true にすればテストモードになる
  eo.OverwriteMode = NExtract::NOverwriteMode::kAskBefore;
  eo.OutputDir = outputDir.c_str(); // 出力ディレクトリ
  eo.YesToAll = false; // Console プログラムのデフォルトは false
  eo.CalcCrc = false; // Console プログラムのデフォルトは false
#ifdef COMPRESS_MT
  eo.Properties = CObjectVector<CProperty>(); // TODO: 調査, options.ExtractProperties;
#endif
  UString errorMessage;
  CDecompressStat stat;
  HRESULT result = DecompressArchives(
    CodecManager::GetCodecs(),
      formatIndices,
      arcPaths,
      arcPathsFull,
      censor.Pairs.Front().Head,
      eo, impl, impl, errorMessage, stat);
}

SZ_NS_END(szpp)
